<?php

class Lead
{

    private $name, $company, $email, $phone, $did, $package, $status, $note, $link;
    public function __construct($name, $email, $company, $did, $phone = "", $package = "basic", $status = "pending", $note = "", $link = "")
    {
        $this->name = $name;
        $this->company = $company;
        $this->email = $email;
        $this->did = $did;
        $this->phone = $phone;
        $this->package = $package;
        $this->status = $status;
        $this->note = $note;
        $this->link = $link;
    }

    public function to_json()
    {
        $lead = array(
            'package' => $this->package,
            'did' => $this->did,
            'name' => $this->name,
            'email' => $this->email,
            'status' => $this->status,
            "company" => $this->company,
            "note" => $this->note,
            "link" => $this->link,
        );
        return json_encode($lead);
    }

    public function change_link($link)
    {
        $this->link = $link;
    }

    private static function parse_name($name)
    {
        $name_parts = explode(" ", $name);
        return array(
            'first' => $name_parts[0],
            'last' => $name_parts[1]
        );
    }
    private static function get_package($value)
    {
        $value = trim($value, " ");

        switch ($value) {
            case ($value == "0" || $value == "(19.95 USD)"):
                return "basic";
            case ($value == "1" || $value == "(59.95 USD)"):
                return "standard";
            case ($value == "2" || $value == "(99.95 USD)"):
                return "deluxe";
            case ($value == "3" || $value == "(199.95 USD)"):
                return "executive";
        }
        return $value;
    }

    public static function parse_data($data)
    {
        $package = Lead::get_package($data["package"]);
        $name = '';

        if (array_key_exists('customer_name', $data)) {
            $name = Lead::parse_name($data['customer_name']);
        } else {
            $name = Lead::parse_name($data["firstname"] . " " . $data["lastname"]);
        }

        return array(
            'package' => $package,
            'did' => $data["number"],
            'name' => $name,
            'email' => $data["email"],
            'status' => 'pending',
            "company" => $data["companyname"],
            "phone" => $data["phone1"]
        );
    }
}


abstract class Logger
{
    public static function create_lead($log)
    {

        $name = $log["name"];
        $company = $log["company"];
        $email = $log["email"];
        $did = $log["did"];
        $phone = $log["phone"];
        $package = $log["package"];
        $status = $log["status"];
        $note = $log["note"];

        return new Lead($name, $email, $company, $did, $phone, $package, $status, $note);
    }

    private static function make_request(String $method, Lead $lead)
    {
        $endpoint = "https://api.telidesk.com/v1/leads";
        $ch = curl_init();
        $payload = $lead->to_json();

        switch ($method) {
            case "POST":
                curl_setopt($ch, CURLOPT_URL, $endpoint);
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
            case "PUT":
                curl_setopt($ch, CURLOPT_URL, $endpoint);
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
        }

        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "Content-Type: application/json",
            "Authorization: Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpZCI6IjYxOGY0YzAwNjNiYjI3NGI2YTQ3YjU0ZCIsImlhdCI6MTY0MzIyNjE2OSwiZXhwIjoxNjUzNTk0MTY5fQ.aR2L77_HaKmS6Ri4JADb5ZSeufc0LZ-XCl5EfXlcaFo",
        ));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

        $response = curl_exec($ch);
        echo $response;

        curl_close($ch);
    }

    public static function add_new_lead(Lead $lead)
    {
        Logger::make_request('POST', $lead);
    }

    public static function update_lead(Lead $lead)
    {
        Logger::make_request('POST', $lead);
    }
}
